@props(['method', 'selected' => false, 'clickable' => false])

@php
    $selected = (bool) $selected;
    $clickable = (bool) $clickable;
@endphp

<div @class([
    'group flex items-center gap-4 rounded-2xl border px-6 py-2 transition shadow-sm',
    'bg-white dark:bg-gray-800 backdrop-blur-xl border-gray-200 dark:border-gray-700 hover:shadow-md hover:border-sky-400' =>
        $clickable && !$selected,
    'border-sky-500 bg-sky-50 dark:bg-sky-950 shadow-md' => $selected,
])>

    {{-- Logo with Glass Effect --}}
    <div
        class="flex h-12 w-12 items-center justify-center rounded-xl 
           bg-white/30 dark:bg-gray-500/30 
           backdrop-blur-sm backdrop-saturate-150 
           border border-white/20 dark:border-gray-400/20 
           shadow-inner">
        @if ($method->logo)
            <img src="{{ $method->logo_url }}" alt="{{ $method->name }} logo" class="h-7 w-7 object-contain">
        @else
            <x-icons.default-payment class="w-7 h-7 text-sky-300 dark:text-gray-200" />
        @endif
    </div>

    {{-- Label --}}
    <div class="flex-1 text-left">
        <p class="font-medium text-gray-900 dark:text-gray-100">
            {{ $method->name }}
        </p>

        @if ($clickable)
            <p class="text-xs text-gray-500">
                Fast & secure payment
            </p>
        @else
            <p class="text-xs text-gray-500 dark:text-gray-400">
                Selected payment method
            </p>
        @endif
    </div>

    {{-- CTA --}}
    @if ($clickable)
        <span
            class="text-xs px-3 py-1 rounded-full bg-gray-100 dark:bg-gray-800 text-gray-500
         group-hover:bg-sky-600 group-hover:text-white transition">
            Select
        </span>
    @elseif($selected)
        <x-flux::button wire:click="resetSelection" variant="primary" size="sm"
            class="bg-sky-600 text-white hover:bg-sky-700">
            Change</x-flux::button>
    @endif

</div>
