@props([
    'href',
    'text',
    'routeName',
])

@php
    $isActive = request()->routeIs($routeName . '*');

    $baseClasses = '
        relative
        inline-flex
        items-center
        h-10
        px-1
        text-sm
        uppercase
        font-semibold
        tracking-wide
        transition-all
    duration-150
        transition-colors
pb-1
    ';

    $activeClasses = '
        text-[#0E4D92] 
        after:absolute 
        after:bottom-0 
        after:left-0 
        after:h-[2px] 
        after:w-full 
        after:bg-[#0E4D92]
    ';

    $inactiveClasses = '
        text-gray-800 
        hover:text-[#0E4D92]
    ';
@endphp

<a href="{{ $href }}"
   class="{{ $baseClasses }} {{ $isActive ? $activeClasses : $inactiveClasses }}">
    {{ $text }}
</a>
