@props(['title', 'items' => []])

@php
    $dropdownActive = false;

    foreach ($items as $item) {
        if (!empty($item['route']) && request()->routeIs($item['route'] . '*')) {
            $dropdownActive = true;
            break;
        }
    }
@endphp

<div 
    x-data="{ open: {{ $dropdownActive ? 'true' : 'false' }} }"
    class="border-t border-gray-200"
>

    <!-- Parent Toggle -->
    <button 
        @click="open = !open"
        class="w-full flex justify-between items-center py-4 px-1
               text-sm font-semibold uppercase tracking-wide
               text-gray-900 focus:outline-none"
    >
        <span class="relative">

            {{ $title }}

            <!-- Active underline (if child active) -->
            @if($dropdownActive)
                <span class="absolute left-0 -bottom-1 w-full h-0.5 bg-sky-600"></span>
            @endif
        </span>

        <!-- Chevron -->
        <svg 
            :class="open ? 'rotate-180 text-gray-900' : 'text-gray-500'"
            class="w-4 h-4 transform transition-transform duration-200"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
            stroke-width="2"
        >
            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Dropdown Items -->
    <div 
        x-show="open" 
        x-collapse 
        x-cloak 
        class="flex flex-col"
    >
        @foreach ($items as $index => $item)
            @php
                $href = !empty($item['route']) ? route($item['route']) : '#';
                $isActive = !empty($item['route']) && request()->routeIs($item['route'] . '*');
            @endphp

            <a href="{{ $href }}"
               class="px-4 py-3 text-sm transition-colors duration-150
                      border-t border-gray-200
                      {{ $isActive
                          ? 'text-gray-900 font-semibold border-l-4 border-sky-600 bg-gray-50'
                          : 'text-gray-800 hover:bg-gray-50' }}">
                {{ $item['name'] }}
            </a>
        @endforeach
    </div>
</div>
