@props([
    'title' => 'Compare Loans',
    'loans' => [],
    'cols' => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4',
])

<section class="py-8 md:py-12 max-w-7xl mx-auto px-4 sm:px-6 lg:px-0 fade-in-up">
    <h2 class="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12">{{ $title }}</h2>

    <div class="grid {{ $cols }} gap-6">
        @foreach ($loans as $loan)
            <div class="flex flex-col rounded-xl border {{ $loan['border'] ?? 'border-gray-200 dark:border-gray-700' }} bg-white dark:bg-gray-900 shadow hover:shadow-lg transition transform hover:-translate-y-1">
                <div class="p-6 flex flex-col flex-1">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-2">{{ $loan['title'] }}</h3>
                    <p class="text-gray-600 dark:text-gray-300 mb-4">{{ $loan['description'] }}</p>

                    <div class="grid grid-cols-2 gap-2 mb-4 text-sm text-gray-700 dark:text-gray-300">
                        <div class="p-2 rounded {{ $loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50' }} text-center">
                            <span class="block font-semibold">Loan Amount</span>
                            <span class="block font-bold text-gray-900 dark:text-white">{{ $loan['amount'] }}</span>
                        </div>
                        <div class="p-2 rounded {{ $loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50' }} text-center">
                            <span class="block font-semibold">Term</span>
                            <span class="block font-bold text-gray-900 dark:text-white">{{ $loan['term'] }}</span>
                        </div>
                        <div class="p-2 rounded {{ $loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50' }} text-center">
                            <span class="block font-semibold">Prepay</span>
                            <span class="block font-bold text-gray-900 dark:text-white">{{ $loan['prepay'] }}</span>
                        </div>
                        <div class="p-2 rounded {{ $loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50' }} text-center">
                            <span class="block font-semibold">Apply</span>
                            <span class="block font-bold text-gray-900 dark:text-white">{{ $loan['apply'] }}</span>
                        </div>
                    </div>

                    <a href="{{ $loan['ctaLink'] ?? route('user.register') }}" 
                       class="mt-auto text-center px-4 py-2 rounded-lg text-white font-semibold {{ $loan['ctaColor'] ?? 'bg-sky-600 hover:bg-sky-700' }} transition">
                        {{ $loan['ctaText'] ?? 'Apply Now' }}
                    </a>
                </div>
            </div>
        @endforeach
    </div>
</section>
