@props([
    'title' => 'Service',
    'status' => 'None',
    'amount' => null,
    'icon' => 'circle',
    'bgFrom' => 'from-gray-50',
    'bgTo' => 'to-gray-100',
    'textColor' => 'text-gray-700',
    'link' => '#', // New prop for the button URL
])

<div
    {{ $attributes->merge(['class' => 'bg-white dark:bg-gray-900 rounded-lg p-4 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col h-full justify-between']) }}>

    <div class="flex items-center gap-3">
        <div
            class="w-12 h-12 flex items-center justify-center rounded-lg bg-linear-to-br {{ $bgFrom }} {{ $bgTo }}">
            @php
                $iconComponent = 'flux::icon.' . $icon;
            @endphp

            <x-dynamic-component :component="$iconComponent" class="w-6 h-6 {{ $textColor }} dark:text-gray-300" />

        </div>

        <div class="flex-1">
            <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">{{ $title }}</h3>
            <span
                class="text-xs px-2 py-1 rounded-full bg-gray-50 dark:bg-gray-800 {{ $textColor }} dark:text-gray-200 font-medium">
                {{ $status }}
            </span>
        </div>
    </div>

    @if ($amount)
        <div class="mt-3 text-gray-600 dark:text-gray-400 text-xs">
            {{ $amount }}
        </div>
    @endif

    <a href="{{ $link }}"
        class="mt-4 bg-linear-to-br from-gray-800 to-gray-700 text-white text-center py-2 rounded-lg font-medium text-sm hover:opacity-90 transition">
        View Details
    </a>

</div>
