@props([
    'title' => '',
    'description' => '',
    'badgeText' => '',
    'buttonText' => 'Learn More',
    'buttonLink' => '#',
    'benefits' => [],
    'imageGrid' => [],
    'imagePosition' => 'right',
    'bgLight' => 'bg-white dark:bg-gray-950',
    'highlightColor' => 'text-primary-700 dark:text-primary-400',
])

<section class="py-8 md:py-12 {{ $bgLight }}">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">
        <div class="grid lg:grid-cols-2 gap-16 items-start">

            <!-- Content -->
            <div class="{{ $imagePosition === 'left' ? 'order-2' : 'order-1' }} space-y-8">

                @if($badgeText)
                    <div class="inline-flex items-center px-4 py-2 bg-primary-50 dark:bg-primary-900/30 {{ $highlightColor }} rounded-md text-sm font-semibold border border-primary-200 dark:border-primary-700">
                        <x-flux::icon.hand-coins class="w-4 h-4 mr-2" />
                        {{ $badgeText }}
                    </div>
                @endif

                @if($title)
                    <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white leading-tight">
                        {{ $title }}
                    </h2>
                    <div class="w-16 h-1 bg-primary-700"></div>
                @endif

                @if($description)
                    <p class="text-lg text-gray-700 dark:text-gray-400 leading-relaxed max-w-xl">
                        {{ $description }}
                    </p>
                @endif

                <!-- Benefits -->
                @if(!empty($benefits))
                    <div class="space-y-6 pt-4">
                        @foreach($benefits as $benefit)
                            <div class="flex items-start space-x-4">
                                <div class="w-10 h-10 bg-primary-50 dark:bg-primary-900/30 rounded-md flex items-center justify-center">
                                    @if(!empty($benefit['icon']))
                                        <x-flux::icon :name="$benefit['icon']" class="w-5 h-5 text-primary-700 dark:text-primary-400"/>
                                    @endif
                                </div>
                                <div>
                                    @if(!empty($benefit['title']))
                                        <h4 class="font-semibold text-gray-900 dark:text-white mb-1">
                                            {{ $benefit['title'] }}
                                        </h4>
                                    @endif
                                    @if(!empty($benefit['description']))
                                        <p class="text-gray-700 dark:text-gray-400">
                                            {{ $benefit['description'] }}
                                        </p>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif

                <!-- Button -->
                @if($buttonLink)
                    <div class="pt-6">
                        <a href="{{ $buttonLink }}" class="inline-flex items-center px-8 py-3 bg-primary-800 hover:bg-primary-900 text-white font-semibold rounded-md transition-colors duration-200">
                            {{ $buttonText }}
                        </a>
                    </div>
                @endif
            </div>

            <!-- Image Grid -->
            <div class="{{ $imagePosition === 'left' ? 'order-1' : 'order-2' }} grid grid-cols-2 gap-6">
                @foreach($imageGrid as $img)
                    <div class="relative aspect-square overflow-hidden rounded-lg border border-gray-200 dark:border-gray-800">
                        <img 
                            src="{{ $img['src'] }}" 
                            alt="{{ $img['alt'] ?? '' }}" 
                            class="w-full h-full object-cover"
                        >
                    </div>
                @endforeach
            </div>

        </div>
    </div>
</section>
