@props([
    'title' => '',
        'gridCols' => 3,
    'items' => [],   
        'center' => 'max-w-6xl mx-auto'
])
@php
    $gridClass = "sm:grid-cols-1 md:grid-cols-{$gridCols}";
@endphp
<section class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-6">

        <!-- Intro -->
        @if($title || trim($slot))
            <div class="space-y-4 max-w-3xl">
                @if($title)
                    <h2 class="text-primary-600 text-3xl md:text-4xl tracking-wide font-semibold">
                        {{ $title }}
                    </h2>
                @endif

                <!-- Subtitle slot -->
                @if(trim($slot))
                    <p class="text-gray-700 dark:text-gray-300 text-base md:text-lg leading-relaxed">
                        {!! $slot !!}
                    </p>
                @endif
            </div>
        @endif

        <!-- Criteria items -->
        @if(!empty($items))
            <div class="space-y-8">
                         <h3 class="text-xl md:text-2xl font-semibold text-gray-900 dark:text-gray-50">
                {{ config('app.name') }}™ meets four foundational criteria:
            </h3>
                          <div class="grid gap-8 {{ $gridClass }} {{ $center }}">
                    @foreach($items as $index => $item)
                        <li class="flex gap-6 items-start group">
                            <div class="shrink-0 w-16 h-16 md:w-24 md:h-24 flex items-center justify-center rounded-full {{ $item['color'] ?? 'bg-primary-600' }} text-white font-bold text-xl md:text-2xl transition-transform duration-300 group-hover:scale-105">
                                {{ $index + 1 }}
                            </div>
                            <div>
                                <h4 class="text-lg md:text-xl font-semibold text-gray-900 dark:text-gray-50">
                                    {{ $item['title'] }}
                                </h4>
                                <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                                    {!! $item['description'] !!}
                                </p>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
</section>
