@props([
    'title' => 'Frequently Asked Questions',
    'faqs' => [], // Array of ['question' => '', 'answer' => '']
])

<section class="relative bg-gray-50 dark:bg-gray-900 py-8 md:py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8 fade-in-up">
        <!-- Section Title -->
        <h2 class="text-primary-600 text-3xl md:text-4xl font-semibold tracking-wide">
            {{ $title }}
        </h2>

        <!-- FAQ List -->
        <div class="space-y-4">
            @foreach($faqs as $index => $faq)
                <div x-data="{ open: false }" class="border border-gray-200 dark:border-gray-700 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow duration-200">
                    <!-- Question -->
                    <button @click="open = !open" class="w-full px-6 py-4 text-left flex justify-between items-center bg-white dark:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-primary-500">
                        <span class="text-gray-900 dark:text-white font-medium text-base md:text-lg">
                            {{ $faq['question'] }}
                        </span>
                        <svg :class="{'rotate-45': open}" class="w-5 h-5 text-gray-500 transform transition-transform duration-300" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                        </svg>
                    </button>

                    <!-- Answer -->
                    <div x-show="open" x-collapse x-cloak class=" bg-gray-50 dark:bg-gray-900 text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed">
                      <div class="px-6 py-4">
                          {!! $faq['answer'] !!}
                      </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>
