@props([
    'align' => 'right', // left, right, center
    'width' => '48', // Tailwind width units
])

<div wire:key="dropdown-{{ $attributes->get('wire:key') }}" class="relative" x-data="{ openDropdownId: null }"
    @keydown.escape.window="openDropdownId = null">

    {{-- Trigger --}}
    <div
        @click="openDropdownId = (openDropdownId === {{ $attributes->get('wire:key') }} ? null : {{ $attributes->get('wire:key') }})">
        {{ $trigger }}
    </div>

    {{-- Dropdown Menu --}}
    <div x-show="openDropdownId === {{ $attributes->get('wire:key') }}" x-cloak
        x-transition:enter="transition ease-out duration-150" x-transition:enter-start="opacity-0 scale-95"
        x-transition:enter-end="opacity-100 scale-100" x-transition:leave="transition ease-in duration-100"
        x-transition:leave-start="opacity-100 scale-100" x-transition:leave-end="opacity-0 scale-95"
        @click.away="openDropdownId = null"
        class="absolute z-50 mt-2 rounded-md shadow-lg bg-white dark:bg-gray-800 ring-1 ring-black ring-opacity-5 focus:outline-none"
        :class="{
            'right-0': '{{ $align }}'
            === 'right',
            'left-0': '{{ $align }}'
            === 'left',
            'center-0': '{{ $align }}'
            === 'center'
        }"
        :style="'min-width: ' + ({{ $width }} * 0.25) + 'rem'">
        <div class="py-1">
            {{ $content }}
        </div>
    </div>
</div>
