@props([
    'details' => []
])

{{-- ================= Details ================= --}}
<div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
    @foreach ($details as $item)
        <div x-data="{ copied: false }"
            class="flex items-center justify-between gap-4 rounded-xl border
                   border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800 p-4 shadow-sm">

            {{-- Info Section --}}
            <div class="flex flex-col capitalize gap-1">
                <p class="text-sm font-semibold text-gray-700 dark:text-gray-300">
                    {{ $item['field1'] ?? '' }}
                </p>

                <p class="text-base font-medium text-gray-900 dark:text-gray-100">
                    {{ $item['field2'] ?? '' }}
                </p>
            </div>

            {{-- Copy Button --}}
            <button
                @click="
                    navigator.clipboard.writeText(
                        '{{ $item['field1'] ?? '' }}: {{ $item['field2'] ?? '' }}'
                    );
                    copied = true;
                    setTimeout(() => copied = false, 1500);
                "
                type="button"
                class="flex items-center justify-center h-10 w-10 rounded-lg
                       bg-sky-600 hover:bg-sky-700 text-white transition
                       focus:outline-none focus:ring-2 focus:ring-sky-400">
                <template x-if="!copied">
                    <x-flux::icon.clipboard class="w-5 h-5" />
                </template>

                <template x-if="copied">
                    <x-flux::icon.check class="w-5 h-5" />
                </template>
            </button>
        </div>
    @endforeach
</div>
