@props(['charge', 'total', 'currencySymbol', 'amountEntered' => false])

<div class="space-y-2 text-sm">
    <!-- Fee -->
    <div class="flex justify-between items-center">
        <span class="text-gray-700 dark:text-gray-300">Fee:</span>
        @if ($amountEntered)
            @if ($charge > 0)
                <span class="font-medium text-gray-800 dark:text-gray-100">
                    {{ $currencySymbol }}{{ number_format($charge, 2) }}
                </span>
            @else
                <span
                    class="font-semibold text-green-600 dark:text-green-400 bg-green-100 dark:bg-green-900/50 px-2 py-0.5 rounded-full text-xs">
                    Free
                </span>
            @endif
        @else
            <span class="text-gray-400 dark:text-gray-500">–</span>
        @endif
    </div>

    <!-- Total -->
    <div class="flex justify-between items-center font-semibold border-t border-gray-200 dark:border-gray-700 pt-2">
        <span class="text-gray-800 dark:text-gray-100">Total to Pay:</span>
        @if ($amountEntered)
            <span class="text-gray-900 dark:text-gray-50">
                {{ $currencySymbol }}{{ number_format($total, 2) }}
            </span>
        @else
            <span class="text-gray-400 dark:text-gray-500">–</span>
        @endif
    </div>
</div>
