@props([
    'title' => 'Payment',
    'icon' => 'exclamation-circle', // default icon name
    'iconColor' => 'text-sky-600',
    'iconBg' => 'bg-sky-100 dark:bg-sky-900',
])

<div class="flex flex-col items-center justify-center py-20 text-center px-4">
    {{-- Icon --}}
    <div class="flex h-20 w-20 items-center justify-center rounded-full {{ $iconBg }} {{ $iconColor }} mb-6">
        <x-dynamic-component :component="'flux::icon.' . $icon" class="w-10 h-10" aria-hidden="true" />
    </div>

    {{-- Heading --}}
    <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-100 mb-2">
        No {{ $title }} Methods Available
    </h2>

    {{-- Description --}}
    <p class="max-w-md text-sm text-gray-500 dark:text-gray-400 mb-6">
        There are currently no {{ strtolower($title) }} methods enabled. Please check back later
        or contact support if you believe this is an error.
    </p>

    {{-- Support Button --}}
    <x-flux::button href="{{ route('user.ticket.create') }}" color="sky" size="sm">
        <x-flux::icon.chat-bubble-left-right class="w-4 h-4 mr-1" />
        Contact Support
    </x-flux::button>
</div>
