@props(['wallets', 'selectedCoin', 'walletAddress', 'walletQrCode'])

<div class="rounded-2xl border border-sky-200 dark:border-sky-800 bg-sky-50 dark:bg-sky-950 p-6 space-y-5 relative">

    <!-- Loading Overlay -->
    <div wire:loading wire:target="selectedPaymentMethodCoin"
        class="absolute inset-0 bg-white/70 dark:bg-gray-900/70 rounded-2xl z-50 flex items-center justify-center">

        <!-- Inner div for centering with transform -->
        <div class="transform -translate-x-1/2 -translate-y-1/2 absolute top-1/2 left-1/2">
            <flux:icon.loading class="w-8 h-8 text-sky-600 dark:text-sky-400 animate-spin" />
        </div>
    </div>

    <h4 class="text-sm font-semibold text-sky-900 dark:text-sky-200">Cryptocurrency Wallet</h4>

    <flux:select wire:model.live="selectedPaymentMethodCoin" label="Select Crypto Type">
        <option value="" disabled>Crypto Type</option>
        @foreach ($wallets as $wallet)
            <option value="{{ $wallet->code }}">{{ $wallet->name }}</option>
        @endforeach
    </flux:select>

    @if ($walletAddress)
        <div class="flex flex-col items-center gap-3 pt-4">
            <h2 class="text-lg font-semibold text-gray-700 dark:text-gray-200 mb-2">Scan to Pay</h2>
            {!! $walletQrCode !!}
            <div x-data="{ copied: false }" class="flex items-center gap-2">
                <p x-ref="textToCopy"
                    class="font-mono text-xs bg-white dark:bg-gray-900 text-gray-600 dark:text-gray-50 px-4 py-2 rounded-lg border border-gray-200 dark:border-gray-700 break-all">
                    {{ $walletAddress }}
                </p>
                <button
                    @click="navigator.clipboard.writeText($refs.textToCopy.innerText); copied = true; setTimeout(()=>copied=false,1500)"
                    class="flex items-center justify-center h-8 w-8 rounded-lg bg-sky-600 hover:bg-sky-700 text-white transition focus:outline-none focus:ring-2 focus:ring-sky-400"
                    type="button">
                    <template x-if="!copied"><x-flux::icon.clipboard class="w-4 h-4" /></template>
                    <template x-if="copied"><x-flux::icon.check class="w-4 h-4" /></template>
                </button>
            </div>
        </div>
    @endif
</div>
