@props(['currencySymbol', 'amount'])

{{-- Amount Selector --}}
<div x-data="{ selected: @js($amount) }" x-init="$watch('selected', value => $wire.set('amount', value))" class="space-y-2 min-h-20">

    {{-- Input Field --}}
    <x-flux::input x-model="selected" :label="__('Amount')" type="number" placeholder="{{ $currencySymbol }}10" />

    {{-- Preset Buttons --}}
    <div class="mt-2 flex flex-wrap gap-2">
        <template x-for="amt in [100, 500, 1000, 5000]" :key="amt">
            <button type="button" @click="selected = amt"
                :class="selected == amt ?
                    'bg-sky-600 text-white' :
                    'bg-sky-100 text-sky-800'"
                class="px-3 py-1 rounded text-xs font-semibold">
                {{ $currencySymbol }}<span x-text="amt"></span>
            </button>
        </template>
    </div>
</div>
