<!-- Confirmation Modal -->
@props(['accounts', 'paymentMethods', 'prevalidatedData', 'currencySymbol'])

<x-modal maxWidth="max-w-lg" @open-confirmation-modal.window="openModal()" @close-confirmation-modal.window="close()"
    x-on:confirmation-success.window="close()">

    {{-- Header --}}
    <div class="flex items-start gap-4 mb-6">
        <div
            class="w-11 h-11 aspect-square rounded-xl flex items-center justify-center
bg-white/20 dark:bg-white/10
backdrop-blur-md
border border-white/30 dark:border-white/10
shadow-[0_0_20px_rgba(56,189,248,0.25)]">

            <x-flux::icon.check-circle variant="solid" class="w-5 h-5 text-sky-700 dark:text-sky-400" />
        </div>

        <div>
            <h2 class="text-lg font-semibold text-gray-900 dark:text-white">
                Confirm Transfer
            </h2>
            <p class="mt-1 text-sm text-gray-600 dark:text-gray-300 leading-relaxed">
                Please review your transfer details carefully. Once submitted,
                this transaction cannot be reversed.
            </p>
        </div>
    </div>

    {{-- Summary Card --}}
    <div
        class="mb-6 rounded-xl border border-gray-200/60 dark:border-gray-700
bg-gray-50/60 dark:bg-gray-800/60
backdrop-blur-sm p-4 space-y-2">

        <div class="flex justify-between text-sm">
            <span class="text-gray-500">Account</span>
            <span class="font-medium text-gray-900 dark:text-white">
                {{ $accounts->firstWhere('id', $prevalidatedData['selectedAccount'] ?? null)?->account_number ?? 'N/A' }}
            </span>
        </div>

        <div class="flex justify-between text-sm">
            <span class="text-gray-500">Payment Method</span>
            <span class="font-medium text-gray-900 dark:text-white">
                {{ $paymentMethods->firstWhere('id', $prevalidatedData['selectedMethod'] ?? null)?->name ?? 'N/A' }}
            </span>
        </div>

        @if (!empty($prevalidatedData['selectedCoin']))
            <div class="flex justify-between text-sm">
                <span class="text-gray-500">Coin</span>
                <span class="font-medium text-gray-900 dark:text-white">
                    {{ $prevalidatedData['selectedCoin'] }}
                </span>
            </div>
        @endif

        <div class="flex justify-between text-sm">
            <span class="text-gray-500">Amount</span>
            <span class="font-medium">
                {{ $currencySymbol }}{{ number_format($prevalidatedData['amount'] ?? '0', 2) }}
            </span>
        </div>

        <div class="flex justify-between text-sm">
            <span class="text-gray-500">Fee</span>
            <span class="font-medium">
                @if (($prevalidatedData['fee'] ?? 0) > 0)
                    {{ $currencySymbol }}{{ number_format($prevalidatedData['fee'], 2) }}
                @else
                    <span class="text-green-600 dark:text-green-400 font-semibold">
                        Free
                    </span>
                @endif
            </span>
        </div>

        <div class="flex justify-between pt-2 border-t border-gray-200/60 dark:border-gray-700 text-sm">
            <span class="font-semibold text-gray-700 dark:text-gray-200">
                Total
            </span>
            <span class="font-semibold text-gray-900 dark:text-white">
                {{ $currencySymbol }}{{ number_format($prevalidatedData['total'] ?? '0', 2) }}
            </span>
        </div>
    </div>

    {{-- Entered Details --}}
    @if (!empty($prevalidatedData['fieldValues']))
        <div class="mb-6">
            <h3 class="text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                Transfer Details
            </h3>

            <div class="rounded-xl border border-gray-200/60 dark:border-gray-700 p-4 space-y-2 text-sm">
                @foreach ($prevalidatedData['fieldValues'] as $key => $value)
                    <div class="flex justify-between gap-4">
                        <span class="text-gray-500">
                            {{ ucwords(str_replace('_', ' ', $key)) }}
                        </span>
                        <span class="font-medium text-gray-900 dark:text-white text-right">
                            {{ $value ?: 'N/A' }}
                        </span>
                    </div>
                @endforeach

                @if (!empty($prevalidatedData['receiverName']))
                    <div class="flex justify-between gap-4">
                        <span class="text-gray-500">
                            Recipient Name
                        </span>
                        <span class="font-medium text-gray-900 dark:text-white text-right capitalize">
                            {{ $prevalidatedData['receiverName'] ?? 'N/A' }}
                        </span>
                    </div>
                @endif
            </div>

        </div>
    @endif

    <div class="my-3">
        <!-- PIN input -->
        <x-input type="password" maxlength="4" label="Transaction Pin" inputmode="numeric" wire:model.defer="pin"
            placeholder="****" viewable />
    </div>

    <div class="relative w-full h-6 bg-gray-200 dark:bg-gray-700 rounded overflow-hidden" wire:loading
        wire:target="confirmTransfer">
        <!-- Progress bar filling -->
        <div
            class="absolute top-0 left-0 h-full bg-green-600 dark:bg-green-400 flex items-center justify-center text-white font-medium text-sm animate-fill">
            Transferring...
        </div>
    </div>

    {{-- Actions --}}
    <div class="flex justify-end gap-3">
        <x-button type="button" variant="ghost" @click="$dispatch('close-confirmation'); $wire.cancelConfirmation()">
            Cancel
        </x-button>

        <x-button type="button" wire:click="confirmTransfer" class="bg-sky-600 hover:bg-sky-700 text-white">
            Confirm & Submit
        </x-button>
    </div>

</x-modal>
