@props([
    'title',
    'value',
    'currency' => false,
    'icon' => null, // icon name
    'iconColor' => 'text-gray-400', // icon color
    'iconVariant' => 'solid', // icon variant
    'iconBg' => null, // optional icon background
])

<div
    class="bg-white dark:bg-gray-800 rounded-xl shadow p-5 hover:shadow-lg transition duration-300 flex items-center justify-between">

    {{-- Text content --}}
    <div>
        <h4 class="text-xs text-gray-500 dark:text-gray-100 uppercase mb-2">{{ $title }}</h4>
        <p class="text-base md:text-xl font-bold text-gray-500 dark:text-gray-100">
            @if ($currency)
                $
            @endif{{ $value }}
        </p>
    </div>

    {{-- Optional Icon --}}
    @if ($icon)
        <div class="ml-4 rounded-md p-3 aspect-square {{ $iconBg ?? '' }}">
            <x-dynamic-component :component="'flux::icon.' . $icon" class="w-6 h-6 {{ $iconColor }}" :variant="$iconVariant" />
        </div>
    @endif

</div>
