@props([
    'title' => '', // Section title
    'icon' => '', // Icon name for <x-flux::icon.*>
    'iconColor' => 'bg-sky-900', // Background color for icon circle
    'features' => [], // Array of features: ['description' => '', 'list' => []]
    'ctaText' => '', // Button text
    'ctaLink' => '', // Button URL
    'iconVariant' => null, // Icon variant: solid, outline, or null for no variant
])

<section class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden py-16">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">
        <div class="flex flex-col md:flex-row items-start md:items-stretch gap-8 md:gap-12">
            
            <!-- Icon Circle -->
            @if ($icon)
                <div class="shrink-0">
                <div class="group w-28 h-28 flex items-center justify-center rounded-full {{ $iconColor }} text-white shadow-lg hover:shadow-xl transition-shadow duration-300">
                    <x-dynamic-component 
                        :component="'flux::icon.' . $icon" 
                        class="w-10 h-10 group-hover:scale-110 transition-transform transform ease-in-out duration-300" 
                          :variant="$iconVariant" 
                    />
                </div>
            </div>
            @endif

            <!-- Content -->
            <div class="md:flex-1 space-y-6">
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white">{{ $title }}</h2>

           @if(!empty($features['description'] ?? null))
    <p class="text-gray-700 dark:text-gray-300 text-lg leading-relaxed">
        {!! nl2br(e($features['description'])) !!}
    </p>
@endif


                @if(!empty($features['list'] ?? null))
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">Key Features:</h3>
                    <ul class="space-y-3 list-none">
                        @foreach($features['list'] as $feature)
                            <li class="flex items-center gap-2">
                                <span class="text-green-500">✔</span> {{ $feature }}
                            </li>
                        @endforeach
                    </ul>
                @endif
@if ($ctaText)
    
                <!-- CTA Button -->
                <a href="{{ $ctaLink }}" class="inline-flex items-center gap-3 px-6 py-3 bg-sky-900 text-white font-semibold rounded-full shadow hover:bg-primary-800 transition-colors duration-300">
                    {{ $ctaText }}
                    <x-flux::icon.arrow-right class="w-5 h-5" variant="solid" />
                </a>
@endif
            </div>
        </div>
    </div>
</section>
