<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\CreditCard;
use App\Models\User;

class CreditCardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all users
        $users = User::all();

        if ($users->isEmpty()) {
            $this->command->info('No users found, skipping credit card seeding.');
            return;
        }

        foreach ($users as $user) {
            // Each user gets 1-3 cards
            $cardsCount = rand(1, 3);

            for ($i = 0; $i < $cardsCount; $i++) {
                $type = ['visa', 'mastercard', 'amex', 'discover'][array_rand(['visa', 'mastercard', 'amex', 'discover'])];

                CreditCard::create([
                    'user_id' => $user->id,
                    'card_type' => $type,
                    'status' => ['active', 'blocked', 'pending'][array_rand(['active', 'blocked', 'pending'])],
                    // card_number, last_four, expiry_date, requested_at will auto-generate
                ]);
            }
        }

        $this->command->info('Credit cards seeded successfully!');
    }
}
