<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('loan_installments', function (Blueprint $table) {
            $table->id();

            $table->foreignId('loan_id')
                ->constrained()
                ->cascadeOnDelete();

            $table->integer('installment_number');

            $table->decimal('principal', 15, 2);
            $table->decimal('interest', 15, 2);
            $table->decimal('penalty', 15, 2)->default(0);
            $table->decimal('total', 15, 2);

            $table->date('due_date');
            $table->timestamp('paid_at')->nullable();

            $table->enum('status', [
                'pending',
                'paid',
                'overdue'
            ])->default('pending');

            $table->timestamps();

            $table->unique(['loan_id', 'installment_number']);

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('loan_installments');
    }
};
