<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('grants', function (Blueprint $table) {
            $table->id();
            // Grant type: personal, corporate, etc.
            $table->string('type');

            // Who submitted the grant (nullable for organizations)
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade');

            // Requested amount
            $table->decimal('amount', 12, 2);

            // JSON field for selected purposes (e.g., program_funding)
            $table->json('purposes')->nullable();

            // Optional metadata: could store corporate info, attachments, etc.
            $table->json('metadata')->nullable();

            $table->enum('status', [
                'pending',
                'in_review',
                'approved',
                'rejected',
                'processed',
                'on_hold',
                'failed'
            ])->default('pending'); // Make sure this is a straight quote, not a curly quote

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('grants');
    }
};
