<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            // Add reference to user's crypto balance (nullable)
            $table->unsignedBigInteger('user_crypto_balance_id')->nullable()->after('crypto_wallet_id');

            // Optional: add foreign key constraint
            $table->foreign('user_crypto_balance_id')
                ->references('id')
                ->on('account_crypto_balances')
                ->onDelete('set null');

            // Add deposit type column
            $table->enum('deposit_type', ['fiat', 'crypto'])->default('fiat')->after('user_crypto_balance_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deposits', function (Blueprint $table) {
            $table->dropForeign(['user_crypto_balance_id']);
            $table->dropColumn(['user_crypto_balance_id', 'deposit_type']);
        });
    }
};
