<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transfers', function (Blueprint $table) {
            $table->id();

            $table->foreignId('account_id')->nullable()->constrained()->nullOnDelete(); // Source account
            $table->uuid('idempotency_key')->unique();
            $table->string('type'); // local_transfer, international, wire, etc.
            $table->decimal('amount', 20, 2); // Transfer amount
            $table->decimal('fee', 20, 2)->default(0); // Fee amount
            $table->decimal('total', 20, 2); // amount + fee

            $table->json('meta')->nullable(); // Dynamic fields depending on type (recipient info, IBAN, SWIFT, etc.)

            $table->enum('status', ['pending', 'completed', 'failed'])->default('pending'); // Transfer status

            $table->timestamps();

            $table->index('account_id');
            $table->index('type');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transfers');
    }
};
