<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('wallet_reserves', function (Blueprint $table) {
            $table->id();
            $table->foreignId('account_id')->constrained()->onDelete('cascade');

            $table->string('action_type'); // e.g., 'card_topup', 'transfer_out', 'booking'
            $table->unsignedBigInteger('action_id')->nullable(); // id of the action (topup request, booking id, etc.)

            $table->decimal('amount', 15, 2); // reserved amount
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->timestamps();
            $table->timestamp('approved_at')->nullable();
            $table->timestamp('locked_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_reserves');
    }
};
