<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('credit_cards', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('card_number')->unique();
            $table->string('card_pin', 4)->nullable();
            $table->string('last_four', 4)->nullable();
            $table->string('card_type'); // Visa, MasterCard, etc.
            $table->enum('status', ['active', 'blocked', 'frozen', 'pending'])->default('pending');
            $table->json('extra_data')->nullable();
            $table->decimal('balance', 15, 2)->default(0); // store balance
            $table->date('expiry_date')->nullable();
            $table->timestamp('requested_at')->nullable();
            $table->timestamps();
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('credit_cards');
    }
};
