<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // e.g., "Bank Transfer", "PayPal"
            $table->string('logo')->nullable(); // Optional logo path
            $table->decimal('fee_percent', 5, 2)->default(0); // percentage fee for this method
            $table->json('instructions')->nullable(); // Optional HTML instructions
            $table->json('details')->nullable(); // Store type-specific details
            $table->json('fields')->nullable();
            $table->string('type')->default('withdrawal'); // or nullable
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->index('is_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_methods');
    }
};
