<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('accounts', function (Blueprint $table) {
            $table->id();
            // One-to-one relation with user
            $table->foreignId('profile_id')->constrained()->onDelete('cascade'); // One profile → many accounts

            // Account info
            $table->string('account_number')->unique();
            $table->string('bank_account_type'); // e.g., savings, checking
            $table->decimal('balance', 15, 2)->default(0); // store balance
            $table->decimal('reserve_balance', 15, 2)->default(0); // store balance
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('accounts');
    }
};
