<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profiles', function (Blueprint $table) {
            $table->id();
            // One-to-one relation with users table
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('client_id')->unique();

            // Basic personal info
            $table->string('username')->unique();
            $table->date('date_of_birth')->nullable();
            $table->enum('gender', ['male', 'female', 'others'])->nullable();
            $table->enum('marital_status', ['single', 'married', 'divorced', 'widowed', 'others'])->nullable();
            $table->string('occupation')->nullable();

            // Contact info
            $table->string('dial_code', 5)->nullable();
            $table->string('phone')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->string('city')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('address_1')->nullable();
            $table->string('address_2')->nullable();
            $table->string('transaction_pin')->nullable(); // hashed transaction pin (optional)
            $table->string('currency', 3);       // USD, EUR, etc.
            $table->string('profile_photo')->nullable(); // store path to uploaded profile image
            $table->enum('status', ['active', 'pending', 'suspended', 'closed'])->nullable();
            $table->boolean('agreement_accepted')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profiles');
    }
};
