<?php

use App\Http\Middleware\EnsureCompleteProfile;
use App\Http\Middleware\EnsureIsAdmin;
use App\Http\Middleware\GuestAdmin;
use App\Http\Middleware\NoIndexAdmin;
use App\Http\Middleware\PreventSuspendedUsers;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        $middleware->alias([
            'complete.profile' => EnsureCompleteProfile::class,
            'session.timeout' => \App\Http\Middleware\SessionTimeout::class, // add this
            'ensure.admin' => EnsureIsAdmin::class,
            'guest.admin' => GuestAdmin::class,
            'noindex.admin' => NoIndexAdmin::class,
            'prevent.suspended' => PreventSuspendedUsers::class,

        ]);
    })
    ->withMiddleware(function ($middleware) {
        $middleware->web([
            \App\Http\Middleware\SetLocale::class,
            // other middleware you need for web
        ]);
    })

    ->withExceptions(function (Exceptions $exceptions): void {
        $exceptions->render(function (\Illuminate\Auth\AuthenticationException $e, $request) {
            // Redirect unauthenticated users to login with flash message
            return redirect()->route('login')->with([
                'message' => 'Please log in to continue.',
                'type' => 'error', // red toast
            ]);
        });
    })->create();
