<?php

namespace App\Providers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use App\Observers\AccountObserver;
use App\Models\Account;
use Illuminate\Support\Facades\Gate;
use App\Models\User;
use App\Policies\UserPolicy;
use Illuminate\Support\Facades\Schema;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Fix for shared hosting MySQL utf8mb4 index length
        Schema::defaultStringLength(191);
        Account::observe(AccountObserver::class);
        View::composer('*', function ($view) {
            $view->with('authUser', Auth::user());
        });
        if (request()->is('admin/*')) {
            Auth::shouldUse('admin');
        }
        Gate::policy(User::class, UserPolicy::class);
    }
}
