<?php

namespace App\Policies;

use App\Models\Admin;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class UserPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function view(Admin $admin, User $user): bool
    {
        if ($admin->isSuperAdmin()) {
            return true;
        }

        if ($admin->isAdmin()) {
            return $user->visibility_level <= 1;
        }

        return false;
    }

    public function viewAny(Admin $admin): bool
    {
        return $admin->isAdmin() || $admin->isSuperAdmin();
    }
    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return false;
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, User $model): bool
    {
        return false;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, User $model): bool
    {
        return false;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, User $model): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, User $model): bool
    {
        return false;
    }

    public function updateVisibility(Admin $admin, User $user): bool
    {
        // Only super_admin can update visibility
        return $admin->isSuperAdmin();
    }
}
