<?php

namespace App\Observers;

use App\Models\Account;

class AccountObserver
{
    /**
     * Handle the Account "created" event.
     */
    public function created(Account $account): void
    {
        // Only create crypto wallets for primary accounts
        if (!$account->is_primary) {
            return;
        }

        // Safety: prevent duplicates
        if ($account->cryptoBalances()->exists()) {
            return;
        }

        foreach (config('crypto.supported') as $coin) {
            $account->cryptoBalances()->create([
                'code' => $coin['code'],
                'network' => $coin['network'],
                'balance' => '0',
                'available_balance' => '0',
                'locked_balance' => '0',
                'is_active' => true,
            ]);
        }
    }

    /**
     * Handle the Account "updated" event.
     */
    public function updated(Account $account): void
    {
        //
    }

    /**
     * Handle the Account "deleted" event.
     */
    public function deleted(Account $account): void
    {
        //
    }

    /**
     * Handle the Account "restored" event.
     */
    public function restored(Account $account): void
    {
        //
    }

    /**
     * Handle the Account "force deleted" event.
     */
    public function forceDeleted(Account $account): void
    {
        //
    }
}
