<?php

namespace App\Notifications;

use App\Models\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TicketReplied extends Notification
{
    use Queueable;
    public $ticket;
    /**
     * Create a new notification instance.
     */
    public function __construct(Ticket $ticket)
    {
        $this->ticket = $ticket;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via($notifiable)
    {
        return ['mail', 'database']; // email + in-app notification
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New Reply to Your Support Ticket')
            ->greeting('Hello ' . $notifiable->name . ',')
            ->line('Your ticket "' . $this->ticket->subject . '" has a new reply from our support team.')
            ->action('View Ticket', url('/account/support/ticket/' . $this->ticket->id))
            ->line('Thank you for using our support system!');
    }


    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase($notifiable)
    {
        return [
            'ticket_id' => $this->ticket->id,
            'message' => 'Your ticket has a new reply from the admin.',
            'link' => '/account/support/ticket/' . $this->ticket->id,
        ];
    }
}
