<?php

namespace App\Notifications;

use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class KycStatusNotification extends Notification
{
    public function __construct(
        public string $documentType,
        public string $status,
        public ?string $reason = null
    ) {
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        $message = (new MailMessage)
            ->subject('KYC Status Update')
            ->greeting('Hello ' . $notifiable->name . ',')
            ->line("Your KYC document ({$this->documentType}) has been {$this->status}.");

        if ($this->status === 'rejected' && $this->reason) {
            $message->line('Rejection Reason: ' . $this->reason);
        }

        return $message->line('Thank you for using our platform.');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'title' => match ($this->status) {
                'verified' => 'Your KYC Document Was Approved',
                'rejected' => 'Your KYC Document Was Rejected',
                default => 'KYC Status Update',
            },
            'type' => 'kyc',
            'document_type' => $this->documentType,
            'status' => $this->status,
            'reason' => $this->reason,
            'message' => "Your KYC document ({$this->documentType}) has been {$this->status}.",
            'link' => '/kyc-documents?type=' . $this->documentType,
        ];
    }
}
