<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TicketMessages extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'admin_id',
        'ticket_id',
        'message',
        'attachments',
        'is_admin',
    ];

    // Cast attachments JSON to array automatically
    protected $casts = [
        'attachments' => 'array',
        'is_admin' => 'boolean'
    ];

    public function ticket()
    {
        return $this->belongsTo(Ticket::class);
    }

    public function admin()
    {
        return $this->belongsTo(Admin::class, 'admin_id');
    }


    public function user()
    {
        return $this->belongsTo(User::class);
    }

}
