<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefundHistory extends Model
{
    use HasFactory;

    protected $fillable = ['refund_id', 'status', 'changed_at', 'notes'];

    protected $casts = [
        'changed_at' => 'datetime',
    ];

    public function refund()
    {
        return $this->belongsTo(TaxRefund::class);
    }
}
