<?php

namespace App\Mail;

use App\Models\TaxRefund;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Attachment;


class TaxRefundReceiptMail extends Mailable
{
    use Queueable, SerializesModels;
    public TaxRefund $refund;
    public string $downloadUrl;
    public $user;


    /**
     * Create a new message instance.
     */
    public function __construct(TaxRefund $refund, string $downloadUrl, $user)
    {
        $this->refund = $refund;
        $this->downloadUrl = $downloadUrl;
        $this->user = $user;
    }
    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "Your Tax Refund Receipt: {$this->refund->filing_number}"
        );
    }
    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'emails.tax-refund-receipt',
            with: [
                'refund' => $this->refund,
                'downloadUrl' => $this->downloadUrl,
                'user' => $this->user,
                'statusHistories' => $this->refund->statusHistories()->orderBy('created_at')->get(),
            ]
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */

    public function attachments(): array
    {
        $pdf = Pdf::loadView('tax-refunds.receipt-pdf', [
            'refund' => $this->refund,
            'statusHistories' => $this->refund->statusHistories()->orderBy('created_at')->get(),
        ])->output();

        return [
            Attachment::fromData(fn() => $pdf, "refund_{$this->refund->filing_number}.pdf")
                ->withMime('application/pdf'),
        ];
    }

}
