<?php


namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class TransactionsExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct(
        protected Collection $transactions
    ) {
    }

    public function collection(): Collection
    {
        return $this->transactions;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Type',
            'Status',
            'Amount',
            'Balance After',
            'Created At',
        ];
    }

    public function map($t): array
    {
        return [
            $t->id,
            $t->type,
            $t->status,
            $t->amount,
            $t->balance_after,
            $t->created_at->toDateTimeString(),
        ];
    }
}
