<?php

namespace App\Enums;

class LoanOptions
{
    // Loan durations in months
    public static function durations(): array
    {
        return [3, 6, 12, 24];
    }

    // Types of credit facilities
    public static function creditFacilities(): array
    {
        return [
            'personal',      // general personal loan
            'business',      // for business purposes
            'emergency',     // urgent needs / unforeseen expenses
            'education',     // tuition or educational expenses
            'home',          // home renovation or purchase
            'auto',          // car or vehicle loans
            'medical',       // medical bills or treatments
            'travel',        // travel or vacation financing
            'wedding',       // weddings or events
            'agriculture',   // farming or agricultural projects
            'equipment',     // purchase of machinery or equipment
            'technology',    // tech or software purchases
            'investment',    // investment or capital projects
            'debt-consolidation', // combine multiple debts
            'green-energy'   // solar panels, energy-efficient upgrades
        ];
    }

    // Employment statuses
    public static function employmentStatuses(): array
    {
        return ['employed', 'self-employed', 'unemployed', 'student', 'retired'];
    }

    // Monthly net income ranges
    public static function netIncomeRanges(): array
    {
        return [
            '0-1000',
            '1001-3000',
            '3001-5000',
            '5001-10000',
            '10001-20000',
            '20001-50000',
            '50001+'
        ];
    }
}
